<?php


namespace Mainto\MRPC\Tool\Net\Conn;


use Mainto\MRPC\Tool\Net\Address;
use Mainto\MRPC\Tool\Net\Conn;
use RuntimeException;

class TcpConn implements Conn {
    /**
     * Socket
     */
    private $socket;
    private string $server;
    private string $port;

    public function __construct ($address) {
        ["host" => $this->server, "port" => $this->port] = parse_url($address);

        $this->socket = @socket_create(AF_INET, SOCK_STREAM, SOL_TCP);

        if (!@socket_connect($this->socket, $this->server, $this->port)) {
            throw new RuntimeException("connect to {$this->server}:{$this->port} error");
        }
    }

    public function close () {
        @socket_close($this->socket);
    }

    public function read (int $size): ?string {
        $res = socket_read($this->socket, $size);
        if ($res === false || $res === "") {
            throw new RuntimeException(sprintf("socket read [%s] error: ".socket_last_error($this->socket), $res === false ? 'false' : 'empty'));
        }

        return $res;
    }

    public function write (string $p): int {
        return socket_write($this->socket, $p);
    }

    public function localAddr (): Address {
        // TODO: Implement localAddr() method.
    }

    public function remoteAddr (): Address {
        // TODO: Implement remoteAddr() method.
    }
}