<?php


namespace Mainto\MRPC\Server\Worker;


use Mainto\MRPC\Protocol\Common\Types\RequestHeaderType;
use Mainto\MRPC\Protocol\Request\Request;
use Mainto\MRPC\Protocol\Response\Response;
use Mainto\MRPC\Server\RpcInvoke;
use Mainto\MRPC\Server\BaseHandler;
use Mainto\MRPC\Tool\Net\Conn;

class ChildHandler extends BaseHandler {
    public function onRequest (Request $request): Response {
        switch ($request->getType()) {
            case RequestHeaderType::SystemCheckType:
                return $this->systemCheckResponse();
            case RequestHeaderType::InvokeNormalType:
            case RequestHeaderType::UrlInvokeDeleteType:
            case RequestHeaderType::UrlInvokePatchType:
            case RequestHeaderType::UrlInvokePostType:
            case RequestHeaderType::UrlInvokePutType:
            case RequestHeaderType::UrlInvokeGetType:

            case RequestHeaderType::MessageNormalType:
            case RequestHeaderType::MessageDelayType:
            case RequestHeaderType::MessageRetryType:

            case RequestHeaderType::CronNormalType:

            case RequestHeaderType::WebsocketNormalType:
            case RequestHeaderType::WebsocketConnectType:
            case RequestHeaderType::WebsocketDisconnectType:
                return RpcInvoke::invoke($request);
        }

        return $this->requestUnknownResponse();
    }

    public function onClose (Conn $socket) {
    }
}