<?php


namespace Mainto\MRPC\Command\Sidecar;


use Mainto\MRPC\Tool\OS;
use RuntimeException;

class Sidecar {
    /**
     * @var array
     */
    private array $sidecarConf;

    private string $baseDir;

    private string $sidecarFilePath = "";

    private string $curOs = "";

    private string $curArch = "";
    /**
     * @var string
     */
    private string $sidecarBaseUrl;
    /**
     * @var string
     */
    private string $runFile;

    public function __construct (string $sidecarBaseUrl) {
        $this->sidecarBaseUrl = $sidecarBaseUrl;
        $this->baseDir = __DIR__."/../..";

        // for check arch
        $_ = $this->getCurArch();

        $this->sidecarConf = array_merge(config('rpc-server.sidecar'), [
            'service_dir'      => base_path(),
            'watch_reload_dir' => app_path(),
            'log_file_dir'     => storage_path("logs/sidecar").'/$year-$month-$day',
            'core_file_path'   => storage_path("logs/core"),

            'rabbitmq_enable'   => config('rpc-server.rabbit_mq.enable'),
            'rabbitmq_host'     => config('rpc-server.rabbit_mq.host'),
            'rabbitmq_port'     => config('rpc-server.rabbit_mq.port'),
            'rabbitmq_username' => config('rpc-server.rabbit_mq.username'),
            'rabbitmq_password' => config('rpc-server.rabbit_mq.password'),
        ]);

        if (!file_exists($this->sidecarConf['core_file_path'])) {
            mkdir($this->sidecarConf['core_file_path'], 0777, true);
        }

        $this->initSidecar();
    }

    public function getCurArch (): string {
        if ($this->curArch === "") {
            $this->curArch = php_uname("m");
            if ($this->curArch != "x86_64") {
                dd("current not support arch {$this->curArch}");
            }
        }

        return $this->curArch;
    }

    public function initSidecar(): void {
        $config = trim(file_get_contents($this->getSidecarFilepath()));
        $runHash = substr(md5($config), 0, 8);
        $this->runFile = $this->getBaseDir()."/../bin/sidecar-{$runHash}";

        if (!file_exists($this->runFile)) {
            $sidecarUrl = $this->getSidecarBaseUrl()."{$config}/{$this->getCurOs()}/amd64/sidecar";

            print "download sidecar from {$sidecarUrl}...\n";

            $data = file_get_contents($sidecarUrl);
            $md5 = file_get_contents("{$sidecarUrl}.md5");

            if (md5($data) != substr($md5, 0, 32)) {
                dd("download sidecar is invalid, please try again later.");
            }

            if (!file_exists(dirname($this->runFile)) && !mkdir(dirname($this->runFile), 0777, true)) {
                dd("mkdir bin dir error");
            }

            if (!file_put_contents($this->runFile, $data)) {
                dd("write sidecar error");
            }

            if (!chmod($this->runFile, 0777)) {
                dd("chmod sidecar error");
            }

            print "download success.\n";
        }
    }

    public function getSidecarFilepath(): string {
        if ($this->sidecarFilePath === "") {
            $this->sidecarFilePath = $this->baseDir."/sidecar_config";
            if (!file_exists($this->sidecarFilePath)) {
                dd("no sidecar config: {$this->sidecarFilePath}");
            }
        }

        return $this->sidecarFilePath;
    }

    /**
     * @return string
     */
    public function getBaseDir (): string {
        return $this->baseDir;
    }

    /**
     * @return string
     */
    public function getSidecarBaseUrl (): string {
        return $this->sidecarBaseUrl;
    }

    public function getCurOs (): string {
        if ($this->curOs === "") {
            $this->curOs = OS::getOs();
            if (!in_array($this->curOs, ["linux", "darwin"])) {
                throw new RuntimeException("current not support os {$this->curOs}");
            }
        }

        return $this->curOs;
    }

    public function addPHPCommandLine (...$args): void {
        if (isset($this->sidecarConf['php_command_line'])) {
            $curCommandLine = json_decode($this->sidecarConf['php_command_line'], true);
            $curCommandLine = array_merge($curCommandLine, $args);
            $this->sidecarConf['php_command_line'] = json_encode($curCommandLine);
        } else {
            $this->sidecarConf['php_command_line'] = json_encode($args);
        }
    }

    /**
     * @return array
     */
    public function getSidecarConf (): array {
        return $this->sidecarConf;
    }

    /**
     * @return string
     */
    public function getRunFile (): string {
        return $this->runFile;
    }
}