<?php
/**
 * Created by PhpStorm.
 * User: PHPStorm
 * Date: 19-2-20
 * Time: 下午4:13
 */

namespace Mainto\MRPC\Command;


use Illuminate\Console\Command;
use Mainto\MRPC\Command\Sidecar\Sidecar;

class RpcSidecar extends Command {
    const SidecarUrl = "https://s3.code.hzmantu.com/";

    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'rpc:sidecar {option?}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'RPC Sidecar Command';

    /**
     * 可用的 Command
     * @var array
     */
    private $commands = [
        'start',
        'download',
    ];

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct () {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle () {
        $command = $this->argument('option');

        if (!$command || !in_array($command, $this->commands)) {
            $this->comment('Usage: php artisan rpc:sidecar {start}');
            return 1;
        }

        $sidecar = new Sidecar(self::SidecarUrl);

        if ($otherConfig = get_cfg_var('cfg_file_path')) {
            $sidecar->addPHPCommandLine('-c', $otherConfig);
        }

        foreach ($sidecar->getSidecarConf() as $key => $value) {
            $keyName = strtoupper("php_sidecar_{$key}");
            if (!getenv($keyName)) {
                putenv($keyName.'='.($value === true ? "true" : $value));
            }
        }

        switch ($command) {
            case "start":
                system($sidecar->getRunFile());
                break;
            case "download":
                break;
        }

        return 0;
    }
}
