<?php


namespace Mainto\MRPC\Client;


use Mainto\MRPC\Tool\Net\Net;

class RpcUnixClient extends BaseRpcClient {
    public static function getServiceClient(string $serviceName) {
        $address = sprintf(self::$baseSocksDir."/rpc_services/%s.sock", $serviceName);

        return new BaseRpcClient(Net::dial("unix", $address));
    }

    public static function getMessageQueueClient() {
        $address = sprintf(self::$baseSocksDir."/mq.sock");

        return new BaseRpcClient(Net::dial("unix", $address));
    }
}
