<?php


namespace Mainto\MRPC\Server;


use Illuminate\Support\Collection;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\HigherOrderCollectionProxy;
use Illuminate\Validation\ValidationException;
use Mainto\MRPC\Exceptions\RpcRuntimeException;
use Mainto\MRPC\Service\RpcParameter;

/**
 * Class RpcParams
 * @package Mainto\MRPC\Server
 */
class RpcParams {
    public array $_declareNames = [];

    private array $params;

    /**
     * 获得声明中的参数
     */
    public function onlyDeclare (): array {
        return array_only($this->params, $this->_declareNames);
    }

    public function __construct ($params = []) {
        $this->params = $params;
    }

    public function only ($params = []): array {
        return array_only($this->params, $params);
    }

    public function get ($key, $default = null) {
        return array_get($this->params, $key, $default);
    }

    public function except ($keys): array {
        return array_except($this->params, $keys);
    }

    public function has ($key): bool {
        return array_has($this->params, $key);
    }
}