<?php
/**
 * Created by PhpStorm.
 * User: PHPStorm
 * Date: 18-12-23
 * Time: 下午4:43
 */

namespace Mainto\MRPC\Command;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\Log;
use Mainto\MRPC\Client\BaseRpcClient;
use Mainto\MRPC\Server\Connection\RpcUnixConnection;
use Mainto\MRPC\Server\Worker\MasterHandler;
use Mainto\MRPC\Tool\SysShm;

class RpcProcessManager extends Command {
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'rpc:pm {--unix=} {--hostname=}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'RPC Cluster Command';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct () {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @throws \Throwable
     */
    public function handle () {
        $unix = $this->option('unix');
        $hostname = $this->option('hostname');
        BaseRpcClient::setBaseSocksDir(sprintf("%s/%s-%s", SysShm::getMemoryMapDir(), config('rpc-server.service_name'), $hostname));

        Log::info("master worker pid: ".getmypid());

        RpcUnixConnection::newInstance($unix, MasterHandler::newInstance())->start();
    }
}
