<?php


namespace Mainto\MRPC\Tool\Binary;


use InvalidArgumentException;
use RuntimeException;

class BigEndian extends Endian {

    public static function uint32ToStr (int $int): string {
        return chr($int >> 24 & 0xFF).chr($int >> 16 & 0xFF).chr($int >> 8 & 0xFF).chr($int & 0xFF);
    }

    public static function strToUint32 (string $str): int {
        if (strlen($str) < 4) {
            throw new InvalidArgumentException("bigEndianStrToInt: str len is too small");
        }

        return ord($str[3]) | (ord($str[2]) << 8) | (ord($str[1]) << 16) | (ord($str[0]) << 24);
    }

    public static function putUint16 (&$str, $start, int $int): void {
        throw new RuntimeException("TODO: Implement");
    }

    public static function intToUint16 (int $int): string {
        throw new RuntimeException("TODO: Implement");
    }
}