<?php


namespace Mainto\MRPC\Protocol\Common\Types;


use Mainto\MRPC\Protocol\Common\BaseType;

class RequestHeaderType {
    /**
     *  - url invoke - 1
     *    + get - 1
     *    + post - 2
     *    + put - 3
     *    + delete - 4
     *    + patch - 5
     */
    const UrlInvokeGetType = ((1 << BaseType::SecondTypeSize) & BaseType::MainTypeMask) | (1 & BaseType::SecondTypeMask);
    const UrlInvokePostType = ((1 << BaseType::SecondTypeSize) & BaseType::MainTypeMask) | (2 & BaseType::SecondTypeMask);
    const UrlInvokePutType = ((1 << BaseType::SecondTypeSize) & BaseType::MainTypeMask) | (3 & BaseType::SecondTypeMask);
    const UrlInvokeDeleteType = ((1 << BaseType::SecondTypeSize) & BaseType::MainTypeMask) | (4 & BaseType::SecondTypeMask);
    const UrlInvokePatchType = ((1 << BaseType::SecondTypeSize) & BaseType::MainTypeMask) | (5 & BaseType::SecondTypeMask);

    /**
     *  - invoke - 2
     *      + normal - 1
     */
    const InvokeNormalType = ((2 << BaseType::SecondTypeSize) & BaseType::MainTypeMask) | (1 & BaseType::SecondTypeMask);

    /**
     *  - message - 3
     *    + normal - 1
     *    + delay - 2
     *    + retry - 3
     */
    const MessageNormalType = ((3 << BaseType::SecondTypeSize) & BaseType::MainTypeMask) | (1 & BaseType::SecondTypeMask);
    const MessageDelayType = ((3 << BaseType::SecondTypeSize) & BaseType::MainTypeMask) | (2 & BaseType::SecondTypeMask);
    const MessageRetryType = ((3 << BaseType::SecondTypeSize) & BaseType::MainTypeMask) | (3 & BaseType::SecondTypeMask);

    /**
     *  - cron - 4
     *    + normal - 1
     */
    const CronNormalType = ((4 << BaseType::SecondTypeSize) & BaseType::MainTypeMask) | (1 & BaseType::SecondTypeMask);

    /**
     *  - websocket - 5
     *    + normal -1
     *    + connect -2
     *    + disconnect -3
     */
    const WebsocketNormalType = ((5 << BaseType::SecondTypeSize) & BaseType::MainTypeMask) | (1 & BaseType::SecondTypeMask);
    const WebsocketConnectType = ((5 << BaseType::SecondTypeSize) & BaseType::MainTypeMask) | (2 & BaseType::SecondTypeMask);
    const WebsocketDisconnectType = ((5 << BaseType::SecondTypeSize) & BaseType::MainTypeMask) | (3 & BaseType::SecondTypeMask);

    /**
     *  - check - 7
     *    + system check 1
     */
    const SystemCheckType = ((7 << BaseType::SecondTypeSize) & BaseType::MainTypeMask) | (1 & BaseType::SecondTypeMask);

    /**
     *  - service control - 8
     *    + scale 1
     *    + master conn 1
     *    + child conn 1
     *    + config 1
     */
    const ServiceScaleType = ((8 << BaseType::SecondTypeSize) & BaseType::MainTypeMask) | (1 & BaseType::SecondTypeMask);
    const ServiceMasterConnType = ((8 << BaseType::SecondTypeSize) & BaseType::MainTypeMask) | (2 & BaseType::SecondTypeMask);
    const ServiceChildConnType = ((8 << BaseType::SecondTypeSize) & BaseType::MainTypeMask) | (3 & BaseType::SecondTypeMask);
    const ServiceConfigType = ((8 << BaseType::SecondTypeSize) & BaseType::MainTypeMask) | (4 & BaseType::SecondTypeMask);
}