<?php
/**
 * Created by PhpStorm.
 * User: jiuli
 * Date: 2018/4/4
 * Time: 下午1:45
 */

namespace Mainto\MRPC\Exceptions;


use Mainto\MRPC\RpcUtil\Block\ErrorReturnBlock;
use Mainto\MRPC\RpcUtil\Block\ReturnBlock;
use Mainto\MRPC\RpcUtil\RpcBlock;
use RuntimeException;

class RpcInvokeException extends RuntimeException {
    /**
     * @var RpcBlock
     */
    private $errorBlock;

    /**
     * RpcInvokeException constructor.
     * @param ReturnBlock $errorBlock
     */
    public function __construct (ReturnBlock $errorBlock) {
        $message = $errorBlock->getMessage();
        $code = 503;
        if ($errorBlock instanceof ErrorReturnBlock) {
            $code = $errorBlock->getErrorCode();
            if ($code <= 0 || !is_numeric($code)) {
                $code = 503;
            }
        }

        if (is_array($message)) {
            parent::__construct(json_encode($message), $code);
        } else {
            parent::__construct($message, $code);
        }

        $this->errorBlock = $errorBlock;
    }
}