<?php
/**
 * Created by PhpStorm.
 * User: PHPStorm
 * Date: 19-2-20
 * Time: 下午4:13
 */

namespace Mainto\MRPC\Command;


use Illuminate\Console\Command;
use Mainto\MRPC\Command\Agent\Agent;

class RpcAgent extends Command {
    const AgentUrl = "https://s3.code.hzmantu.com/";

    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'rpc:agent {option?}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'RPC Agent Command';

    /**
     * 可用的 Command
     * @var array
     */
    private $commands = [
        'start',
        'download',
    ];

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct () {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle () {
        $command = $this->argument('option');

        if (!$command || !in_array($command, $this->commands)) {
            $this->comment('Usage: php artisan rpc:agent {start}');
            return 1;
        }

        $agent = new Agent(self::AgentUrl);

        if ($otherConfig = get_cfg_var('cfg_file_path')) {
            $agent->addPHPCommandLine('-c', $otherConfig);
        }

        foreach ($agent->getAgentConf() as $key => $value) {
            $keyName = strtoupper("php_agent_{$key}");
            if (!getenv($keyName)) {
                putenv($keyName.'='.($value === true ? "true" : $value));
            }
        }

        switch ($command) {
            case "start":
                system($agent->getRunFile());
                break;
            case "download":
                break;
        }

        return 0;
    }
}
