<?php


namespace Mainto\MRPC\Protocol;


use Mainto\MRPC\Tool\Net\Net;

class RpcTcpConnection extends BaseRpcConnection {
    /**
     * RpcServer constructor.
     * @param string $address
     * @param $streamId
     * @param ConnectionHandler $handler
     */
    private function __construct (string $address, $streamId,  ConnectionHandler $handler) {
        parent::__construct($streamId, $handler);

        $this->conn = Net::dial("tcp", $address);
    }

    public static function newInstance(string $address, $streamId,  ConnectionHandler $handler) {
        return new self($address, $streamId, $handler);
    }
}