<?php


namespace Mainto\MRPC\Tool\Net\Listener;


use Mainto\MRPC\Tool\Net\Address;
use Mainto\MRPC\Tool\Net\Conn;
use Mainto\MRPC\Tool\Net\Listener;
use RuntimeException;

class UnixListener implements Listener {
    private Address\UnixAddress $address;
    /**
     * @var false|resource
     */
    private $listenSocket;

    public function __construct (string $address) {
        $listenSocket = @socket_create( AF_UNIX, SOCK_STREAM, 0 );

        if (!@socket_bind($listenSocket, $address)) {
            throw new RuntimeException("bind server [$address] error: ". socket_last_error($listenSocket));
        }

        @socket_listen($listenSocket);

        $this->address = new Address\UnixAddress($address);
        $this->listenSocket = $listenSocket;
    }

    public function close () {
        // TODO: Implement close() method.
    }

    public function accept (): Conn {
        // todo
        socket_accept($this->listenSocket);
    }

    public function address (): Address {
        return $this->address;
    }
}