<?php


namespace Mainto\MRPC\Client;


use Mainto\MRPC\Tool\Net\Socks\UnixSock;
use Mainto\MRPC\Tool\SysShm;

class UnixClient extends RpcClient {
    public function __construct (string $serviceName) {
        $address = sprintf(SysShm::getMemoryMapDir() . "/%s/rpc_services/%s.sock", config('rpc-server.service_name'), $serviceName);

        $this->loadConn($address);
    }

    private function loadConn($address) {
        $this->conn = new UnixSock($address);
    }
}
