<?php


namespace Mainto\MRPC\Server\Worker;


use Mainto\MRPC\Protocol\ConnectionHandler;
use Mainto\MRPC\Protocol\Response\Response;

abstract class BaseHandler implements ConnectionHandler {
    protected ?Response $okResponse = null;
    private ?Response $unknownResponse = null;

    protected function okResponse() {
        if ($this->okResponse === null) {
            $this->okResponse = new Response();
            $this->okResponse->useReturnOKType();
        }

        return $this->okResponse;
    }

    protected function systemCheckResponse() {
        if ($this->okResponse === null) {
            $this->okResponse = new Response();
            $this->okResponse->useReturnOKType();
        }

        return $this->okResponse;
    }

    protected function requestUnknownResponse() {
        if ($this->unknownResponse === null) {
            $this->unknownResponse = new Response();
            $this->unknownResponse->useReturnErrType();
        }

        return $this->unknownResponse;
    }
}