<?php


namespace Mainto\MRPC\Tool\Net\Socks;


use Mainto\MRPC\Tool\Net\Conn;
use Mainto\MRPC\Tool\Net\Exceptions\ServerNotFoundException;
use RuntimeException;

class UnixSock implements Conn {
    /**
     * Socket
     */
    private $socket;

    public function __construct ($address) {
        if (!file_exists($address)) {
            throw new ServerNotFoundException();
        }

        $this->socket = @socket_create(AF_UNIX, SOCK_STREAM, 0);
        if (!$this->socket) {
            throw new RuntimeException("create unix error");
        }

        if (!@socket_connect($this->socket, $address)) {
            throw new RuntimeException("connect unix error:" . socket_last_error($this->socket));
        }
    }

    public function close () {
        @socket_close($this->socket);
    }

    public function read (int $size): ?string {
        if ($size === 0) {
            return "";
        }
        $res = socket_read($this->socket, $size);
        if ($res === false || $res === "") {
            throw new RuntimeException(sprintf("socket read [%s] error: ".socket_last_error($this->socket) . " size: ". $size, $res === false ? 'false' : 'empty'));
        }

        return $res;
    }

    public function write (string $p): int {
        return socket_write($this->socket, $p);
    }
}