<?php


namespace Mainto\MRPC\Protocol\Request\Extend;


use Mainto\MRPC\Protocol\Common\MapReadWrite;
use Mainto\MRPC\Protocol\Request\BodyExtend;
use Mainto\MRPC\Protocol\Request\Extend;
use Mainto\MRPC\Protocol\Request\HeaderExtend;
use Mainto\MRPC\Protocol\Request\QueryExtend;
use Mainto\MRPC\Tool\IO\Reader;
use Mainto\MRPC\Tool\IO\Writer;

class RequestExtendUrlInvoke implements HeaderExtend, BodyExtend, QueryExtend {
    private array $header = [];
    private array $query = [];
    private array $file = [];

    public function magicNum () {
        return Extend::MagicNumUrlInvoke;
    }

    private function checkAndAdd(array &$map, string $key, string $value) {
        if (strlen($key) < 255 && strlen($value) < 65535) {
            if (!isset($map[$key])) {
                $map[$key] = [];
            }

            $map[$key][] = $value;
        }
    }

    private function checkAndSet(array &$map, string $key, array $values) {
        if (strlen($key) > 255) {
            return;
        }

        foreach ($values as $value) {
            if ($value >= 65535) {
                return;
            }
        }

        $map[$key] = $values;
    }

    public function addHeader (string $key, string $value) {
       $this->checkAndAdd($this->header, $key, $value);
    }

    public function setHeader(string $key, array $values) {
        $this->checkAndSet($this->header, $key, $values);
    }

    public function checkParams () {
    }

    /**
     * @return array
     */
    public function getAllHeader (): array {
        return $this->header;
    }

    /**
     * @param string $key
     * @return array
     */
    public function getHeader (string $key): array {
        return $this->header[$key];
    }

    public function setQuery(string $key, array $values) {
        $this->checkAndSet($this->query, $key, $values);
    }

    public function addQuery(string $key, string $value) {
        $this->checkAndAdd($this->query, $key, $value);
    }

    /**
     * @return array
     */
    public function getAllQuery (): array {
        return $this->query;
    }

    /**
     * @param string $key
     * @return array
     */
    public function getQuery (string $key): array {
        return $this->query[$key];
    }

    public function addFile(string $key, Reader $reader) {
        $this->file[$key] = $reader;
    }

    public function writeBodyTo (Writer $writer): int {
        if ($this->file) {
            throw new \RuntimeException("current not support file upload");
        }

        return 0;
    }

    public function readBodyFrom (Reader $reader): int {
        // todo current not support file upload
        return 0;
    }

    public function writeHeaderTo (Writer $writer): int {
        return MapReadWrite::littleWriteMapTo($this->header, $writer);
    }

    public function readHeaderFrom (Reader $reader): int {
        return MapReadWrite::littleReadMapFrom($this->header, $reader);
    }

    /**
     * @inheritDoc
     */
    public function toJson ($options = 0) {
        return json_encode([
            "headers" => $this->header,
            "querys" => $this->query,
        ], $options);
    }

    public function writeQueryTo (Writer $writer): int {
        return MapReadWrite::littleWriteMapTo($this->query, $writer);
    }

    public function readQueryFrom (Reader $reader): int {
        return MapReadWrite::littleReadMapFrom($this->query, $reader);
    }
}