<?php


namespace Mainto\MRPC\Tool\Net\Socks;


use Mainto\MRPC\Tool\Net\Conn;
use RuntimeException;

class TcpSock implements Conn {
    /**
     * Socket
     */
    private $socket;
    private string $server;
    private string $port;

    public function __construct ($host, $port) {
        $this->server = $host;
        $this->port = $port;

        $this->socket = @socket_create(AF_INET, SOCK_STREAM, SOL_TCP);

        if (!@socket_connect($this->socket, $host, $port)) {
            throw new RuntimeException("connect to {$host}:{$port} error");
        }
    }

    public function close () {
        @socket_close($this->socket);
    }

    public function read (int $size): ?string {
        $res = socket_read($this->socket, $size);
        if ($res === false || $res === "") {
            throw new RuntimeException(sprintf("socket read [%s] error: ".socket_last_error($this->socket), $res === false ? 'false' : 'empty'));
        }

        return $res;
    }

    public function write (string $p): int {
        return socket_write($this->socket, $p);
    }
}