<?php


namespace Mainto\MRPC\Tool\Bytes;


class Bytes {
    const MinRead = 512;

    public static function newBuffer() {
        return new Buffer();
    }

    public static function newReader(string $bytes) {
        return new Reader($bytes);
    }

    /**
     * @param int $size
     * @return string
     */
    public static function makeBytes (int $size):string {
        return str_repeat("\x00", $size);
    }

    public static function equal(string $a, string $b):bool {
        return $a === $b;
    }
}