<?php


namespace Mainto\MRPC\Server\Worker;


use Mainto\MRPC\Protocol\Common\Types\RequestHeaderType;
use Mainto\MRPC\Protocol\Request\Request;
use Mainto\MRPC\Protocol\Response\Response;
use Mainto\MRPC\Server\RpcInvoke;
use Mainto\MRPC\Tool\Net\Conn;
use Mainto\MRPC\Tool\OS;

class ChildHandler extends BaseHandler {
    /**
     * @param string $address
     */
    public function __construct (string $address) {
        OS::setProcessTitle(sprintf("rpc-php [%s] [%s] child", config('rpc-server.service_name'), $address));
    }

    public function onRequest (Request $request): Response {
        switch ($request->getType()) {
            case RequestHeaderType::SystemCheckType:
                return $this->systemCheckResponse();
            case RequestHeaderType::InvokeNormalType:
            case RequestHeaderType::UrlInvokeDeleteType:
            case RequestHeaderType::UrlInvokePatchType:
            case RequestHeaderType::UrlInvokePostType:
            case RequestHeaderType::UrlInvokePutType:
            case RequestHeaderType::UrlInvokeGetType:
            case RequestHeaderType::MessageNormalType:
            case RequestHeaderType::CronNormalType:
                return RpcInvoke::invoke($request);
        }

        return $this->requestUnknownResponse();
    }

    public function onClose (Conn $socket) {
    }
}