<?php


namespace Mainto\MRPC\Protocol;


use Mainto\MRPC\Tool\Net\Socks\TcpSock;

class RpcTcpConnection extends BaseRpcConnection {
    /**
     * RpcServer constructor.
     * @param string $host
     * @param string $port
     * @param $streamId
     * @param ConnectionHandler $handler
     */
    private function __construct (string $host, string $port, $streamId,  ConnectionHandler $handler) {
        parent::__construct($streamId, $handler);

        $this->conn = new TcpSock($host, $port);
    }

    public static function newInstance(string $host, string $port, $streamId,  ConnectionHandler $handler) {
        return new self($host, $port, $streamId, $handler);
    }
}