<?php


namespace Mainto\MRPC\Protocol\Request;


use Mainto\MRPC\Protocol\Request\Extend\RequestExtendUrlInvoke;
use RuntimeException;

class ExtendFactory {
    public static array $extendMap = [
        Extend::MagicNumUrlInvoke => RequestExtendUrlInvoke::class
    ];

    public static function getManagedRequestExtendByMagicNum(int $magicNum): Extend {
        if (!isset(self::$extendMap[$magicNum])) {
            throw new RuntimeException("magic is not support");
        }

        $class = self::$extendMap[$magicNum];

        return new $class();
    }
}