<?php


namespace Mainto\MRPC\Command\Agent;


use Mainto\MRPC\Tool\OS;
use RuntimeException;

class Agent {
    /**
     * @var array
     */
    private array $agentConf;

    private string $baseDir;

    private string $agentFilePath = "";

    private string $curOs = "";

    private string $curArch = "";
    /**
     * @var string
     */
    private string $agentBaseUrl;
    /**
     * @var string
     */
    private string $runFile;

    public function __construct (string $agentBaseUrl) {
        $this->agentBaseUrl = $agentBaseUrl;
        $this->baseDir = __DIR__."/../..";

        // for check arch
        $_ = $this->getCurArch();

        $this->agentConf = array_merge(config('rpc-server.agent'), [
            'service_dir'      => base_path(),
            'watch_reload_dir' => app_path(),
            'log_file_dir'     => storage_path("logs/agent").'/$year-$month-$day',
            'core_file_path'   => storage_path("logs/core"),

            'rabbitmq_enable'   => config('rpc-server.rabbit_mq.enable'),
            'rabbitmq_host'     => config('rpc-server.rabbit_mq.host'),
            'rabbitmq_port'     => config('rpc-server.rabbit_mq.port'),
            'rabbitmq_username' => config('rpc-server.rabbit_mq.username'),
            'rabbitmq_password' => config('rpc-server.rabbit_mq.password'),
        ]);

        if (!file_exists($this->agentConf['core_file_path'])) {
            mkdir($this->agentConf['core_file_path'], 0777, true);
        }

        $this->initAgent();
    }

    public function getCurArch (): string {
        if ($this->curArch === "") {
            $this->curArch = php_uname("m");
            if ($this->curArch != "x86_64") {
                dd("current not support arch {$this->curArch}");
            }
        }

        return $this->curArch;
    }

    public function initAgent(): void {
        $config = trim(file_get_contents($this->getAgentFilepath()));
        $runHash = substr(md5($config), 0, 8);
        $this->runFile = $this->getBaseDir()."/../bin/agent-{$runHash}";

        if (!file_exists($this->runFile)) {
            $agentUrl = $this->getAgentBaseUrl()."{$config}/{$this->getCurOs()}/amd64/agent";

            print "download agent from {$agentUrl}...\n";

            $data = file_get_contents($agentUrl);
            $md5 = file_get_contents("{$agentUrl}.md5");

            if (md5($data) != substr($md5, 0, 32)) {
                dd("download agent is invalid, please try again later.");
            }

            if (!file_exists(dirname($this->runFile)) && !mkdir(dirname($this->runFile), 0777, true)) {
                dd("mkdir bin dir error");
            }

            if (!file_put_contents($this->runFile, $data)) {
                dd("write agent error");
            }

            if (!chmod($this->runFile, 0777)) {
                dd("chmod agent error");
            }

            print "download success.\n";
        }
    }

    public function getAgentFilepath(): string {
        if ($this->agentFilePath === "") {
            $this->agentFilePath = $this->baseDir."/agent_config";
            if (!file_exists($this->agentFilePath)) {
                dd("no agent config: {$this->agentFilePath}");
            }
        }

        return $this->agentFilePath;
    }

    /**
     * @return string
     */
    public function getBaseDir (): string {
        return $this->baseDir;
    }

    /**
     * @return string
     */
    public function getAgentBaseUrl (): string {
        return $this->agentBaseUrl;
    }

    public function getCurOs (): string {
        if ($this->curOs === "") {
            $this->curOs = OS::getOs();
            if (!in_array($this->curOs, ["linux", "darwin"])) {
                throw new RuntimeException("current not support os {$this->curOs}");
            }
        }

        return $this->curOs;
    }

    public function addPHPCommandLine (...$args): void {
        if (isset($this->agentConf['php_command_line'])) {
            $curCommandLine = json_decode($this->agentConf['php_command_line'], true);
            $curCommandLine = array_merge($curCommandLine, $args);
            $this->agentConf['php_command_line'] = json_encode($curCommandLine);
        } else {
            $this->agentConf['php_command_line'] = json_encode($args);
        }
    }

    /**
     * @return array
     */
    public function getAgentConf (): array {
        return $this->agentConf;
    }

    /**
     * @return string
     */
    public function getRunFile (): string {
        return $this->runFile;
    }
}