<?php


namespace Mainto\RpcServer\Protocol\Request;


use Mainto\RpcServer\Protocol\Request\Extend\RequestExtendHeader;
use Mainto\RpcServer\Protocol\Request\Extend\RequestExtendUrlInvoke;
use RuntimeException;

class ExtendFactory {
    public static array $extendMap = [
        Extend::MagicNumUrlInvoke => RequestExtendUrlInvoke::class,
        Extend::MagicNumHeaderExtend => RequestExtendHeader::class
    ];

    public static function getManagedRequestExtendByMagicNum(int $magicNum): Extend {
        if (!isset(self::$extendMap[$magicNum])) {
            throw new RuntimeException("magic is not support");
        }

        $class = self::$extendMap[$magicNum];

        return new $class();
    }
}