<?php
/**
 * Created by PhpStorm.
 * User: jiuli
 * Date: 2018/3/25
 * Time: 下午6:16
 */

namespace Mainto\RpcServer\RpcAnnotations;

use Doctrine\Common\Annotations\Annotation\Attribute;
use Doctrine\Common\Annotations\Annotation\Attributes;
use Doctrine\Common\Annotations\Annotation\Enum;

/**
 * Class RpcParam
 * @package Mainto\RpcServer\RpcAnnotations
 *
 * @Annotation
 * @Target({"METHOD"})
 *
 * @Attributes({
 *     @Attribute("name", type = "string"),
 *     @Attribute("require", type="boolean"),
 *     @Attribute("type", type="string"),
 *     @Attribute("comment", type="string"),
 *     @Attribute("example", type="string"),
 *     @Attribute("default", type="mixed"),
 * })
 */
class RpcParam {
    /**
     * 参数名称
     *
     * @Required
     * @var string
     */
    public string $name = "";

    /**
     * 参数是否必须
     *
     * @var bool
     */
    public bool $require = false;

    /**
     * 参数类型
     *
     * @Required
     * @Enum({
     *     "string", "bool",
     *     "int", "uint",
     *     "double", "unsignedDouble",
     *     "array", "array<int>", "array<uint>", "array<string>",
     *     "mixed"
     * })
     * @var string
     */
    public string $type = "";

    /**
     * 运行传null
     * @var bool
     */
    public bool $nullable = false;

    /**
     * 参数说明
     *
     * @Required
     * @var string
     */
    public string $comment;

    /**
     * 参数校验
     *
     * @var string
     */
    public string $validation = "";

    /**
     * 参数样例
     *
     * @var string
     */
    public string $example = "";

    /**
     * 参数默认值
     *
     * @var mixed
     */
    public $default;
}