<?php


namespace Mainto\RpcServer\RpcClient;


use Illuminate\Support\Facades\Log;
use Mainto\RpcServer\Protocol\Request\Request;
use Mainto\RpcServer\Protocol\Response\Response;
use Mainto\RpcServer\Protocol\Response\ResponseReader;
use Mainto\RpcServer\Util\IO\Closer;
use Mainto\RpcServer\Util\Net\Conn;
use Mainto\RpcServer\Util\Net\Net;

class RpcClient implements Closer {
    public static string $baseUnixDir;

    protected Conn $conn;

    private int $pid;

    public function __construct (Conn $conn) {
        $this->pid = getmypid();

        $this->conn = $conn;
    }

    public function Do (Request $request): Response {
        Log::debug("[client send req: {$this->pid}] \n".$request->dump());
        $request->writeTo($this->conn);

        $response = ResponseReader::ReadResponseFrom($this->conn)->toResponse();
        Log::debug("[client recv res: {$this->pid}] \n".$response->dump());

        return $response;
    }

    public function close () {
        $this->conn->close();
    }

    public static function setBaseUnixDir ($dir) {
        self::$baseUnixDir = $dir;
    }

    public static function getServiceClient (string $serviceName) {
        return new self(Net::dial('unix', path_join(self::$baseUnixDir, 'rpc_services', "$serviceName.sock")));
    }

    public static function getMessageQueueClient () {
        return new self(Net::dial("unix", path_join(self::$baseUnixDir, 'mq.sock')));
    }

    public static function getSettingClient () {
        return new self(Net::dial("unix", path_join(self::$baseUnixDir, 'setting.sock')));
    }

    public static function getSLSClient () {
        return new self(Net::dial("unix", path_join(self::$baseUnixDir, 'sls.sock')));
    }
}