<?php


namespace Mainto\RpcServer\Util;

use Mainto\RpcServer\Util\Binary\BigEndian;
use Mainto\RpcServer\Util\Binary\LittleEndian;
use RuntimeException;

class Binary {
    /**
     * @var string|LittleEndian
     */
    public static string $littleEndian = LittleEndian::class;

    /**
     * @var string|BigEndian
     */
    public static string $bigEndian = BigEndian::class;

    /**
     * @param int $size
     * @return string
     */
    public static function makeBytes (int $size):string {
        return str_repeat("\x00", $size);
    }

    /**
     * @param $dist
     * @param $start
     * @param $end
     * @param $src
     */
    public static function copy (&$dist, $start, $end, $src) {
        if ($end - $start === 0) {
            return;
        }

        if ($end > strlen($dist)) {
            throw new RuntimeException(sprintf("buff size offset: max [%d] and given [%d]", strlen($dist), $end));
        }

        if ($src === "") {
            $src = self::makeBytes($end - $start);
        }

        $dist = substr_replace($dist, $src, $start, $end - $start);
    }

    public static function putUint8 (&$str, $start, int $int): void {
        $str = substr_replace($str, self::intToUint8($int), $start, 1);
    }

    public static function intToUint8 (int $int): string {
        return chr($int & 0xFF);
    }

    /**
     * @param string $str
     * @return int
     */
    public static function strToUint8 (string $str): int {
        return ord($str[0]);
    }
}