<?php

return [
    'service_name' => env('RPC_SERVER_NAME', 'NoName'),
    'log_driver'   => env('RPC_LOG_DRIVER', in_array(config('app.env', "local"), ['dev', 'production']) ? 'sls' : 'local'),

    /**
     * rpc api url generation strategy
     */
    'url'          => [
        /**
         * enable auto add url prefix
         */
        'enable_prefix' => !env('RPC_DISABLE_URL_PREFIX', false),

        /**
         * auto add url prefix
         */
        'prefix'        => env("RPC_URL_PREFIX", "/".snake_case(env('RPC_SERVER_NAME', 'NoName'))),
    ],

    /**
     * cron config
     */
    'cron'         => [
        'enable' => env('RPC_CRON_ENABLE', true),
    ],

    'gc'      => [
        /**
         * run force gc when lifetime is full
         */
        'max_lifetime' => 60,

        /**
         * run force gc probability when request is complete
         */
        'probability'  => 5,
    ],

    /**
     * sidecar config (can rewrite by env)
     */
    'sidecar' => [
        // 是否启用配置中心
        'enable_setting' => env('RPC_SIDECAR_SETTING', false),
        // 服务主机名 (仅用于用于一个服务多实例时区分，本地多开可以随意配置， 默认取机器hostname)
        'hostname'       => env("RPC_SIDECAR_HOSTNAME", null),
        'auto_reload'    => [
            'enable'    => config('app.env') == "local",
            // 监控文件变更，热更新 APP_ENV=local 时有效
            'watch_dir' => env("RPC_SIDECAR_AUTO_RELOAD_WATCH_DIR", app_path()),
        ],

        "etcd"    => [
            // 服务注册中心地址
            'server_address' => env("RPC_SIDECAR_ETCD_SERVER_ADDRESS", "127.0.0.1:2379"),
            'dial_timeout'   => env("RPC_SIDECAR_ETCD_DIAL_TIMEOUT", "5"),
        ],
        /**
         * debug / 指标服务对外接口
         */
        'metrics' => [
            'host'        => env("RPC_SIDECAR_METRICS_SERVER_HOST", "0.0.0.0"),
            'port'        => env("RPC_SIDECAR_METRICS_SERVER_PORT", "0"),
            'push_enable' => env("RPC_SIDECAR_METRICS_PUSH_ENABLE", false),
            'push_url'    => env("RPC_SIDECAR_METRICS_PUSH_URL", "http://127.0.0.1:9091"),
        ],

        /**
         * sidecar程序日志
         */
        "log" => [
            'enable_load_debug' => env("RPC_SIDECAR_LOG_ENABLE_LOAD_DEBUG", false),
            'file'              => [
                "path"  => env("RPC_SIDECAR_LOG_FILE_PATH", storage_path("logs/service/sidecar.log")),
                "level" => env("RPC_SIDECAR_LOG_FILE_LEVEL", 'debug'),
            ],
            // 是否输出到终端
            'console'           => [
                "enable" => env("RPC_SIDECAR_LOG_CONSOLE_ENABLE", true),
                "level"  => env("RPC_SIDECAR_LOG_CONSOLE_LEVEL", 'debug'),
            ],
        ],
        /**
         * 是否启用rabbmitmq消息队列
         */
        "rabbitmq" => [
            'enable'   => env("RPC_SIDECAR_RABBIT_ENABLE", true),
            'username' => env("RPC_SIDECAR_RABBIT_USERNAME", "manto"),
            'password' => env("RPC_SIDECAR_RABBIT_PASSWORD", "guest"),
            'host'     => env("RPC_SIDECAR_RABBIT_HOST", "127.0.0.1"),
            'port'     => env("RPC_SIDECAR_RABBIT_PORT", "5672"),
        ],
        "worker"   => [
            'min_worker_num'            => env("RPC_SIDECAR_WORKER_MIN_WORKER_NUM", 18),
            'max_worker_num'            => env("RPC_SIDECAR_WORKER_MAX_WORKER_NUM", 500),
            // worker池锁定内存水位线(内存使用率达到该值后worker不再扩容)
            'num_lock_memory_watermark' => env("RPC_SIDECAR_WORKER_NUM_LOCK_MEMORY_WATERMARK", 80),
            // worker池锁定cpu水位线(cpu使用率达到该值后worker不再扩容)
            'num_lock_cpu_watermark'    => env("RPC_SIDECAR_WORKER_NUM_LOCK_CPU_WATERMARK", 80),
            // worker池缩容负载线(负载率达到该值后将在 RPC_SIDECAR_WORKER_SCALE_DOWN_DURATION (ms)时间后开始缩容)
            'scale_down_load'           => env("RPC_SIDECAR_WORKER_SCALE_DOWN_LOAD", 60),
            // 持续在缩容负载线指定时间开始缩容 (ms)
            'scale_down_duration'       => env("RPC_SIDECAR_WORKER_SCALE_DOWN_DURATION", 60000),
            // worker池扩容负载线(负载率达到该值后将扩容)
            'scale_up_load'             => env("RPC_SIDECAR_WORKER_SCALE_UP_LOAD", 80),
            // 扩容静默时间 (ms) 两次扩容的时间间隔，控制扩容的频率
            'scale_up_clam'             => env("RPC_SIDECAR_WORKER_SCALE_UP_CALM", 300),
            /**
             * 服务监听
             */
            'server'                    => [
                'host' => env("RPC_SIDECAR_WORKER_SERVER_HOST", "0.0.0.0"),
                'port' => env("RPC_SIDECAR_WORKER_SERVER_PORT", "2233"),
            ],
            /**
             * 数据池
             */
            'auto_reject'               => [
                // 数据池最大值
                'max_size'              => env("RPC_SIDECAR_AUTO_REJECT_MAX_SIZE", 500),
                // 数据池进入丢弃模式的大小
                'reject_mode_size'      => env("RPC_SIDECAR_AUTO_REJECT_REJECT_MODE_SIZE", 100),
                // 数据池丢弃模式时的最大等待时间
                'reject_mode_wait_time' => env("RPC_SIDECAR_AUTO_REJECT_REJECT_MODE_WAIT_TIME", 3000),
                // 数据最大等待时间（超出强制丢弃）
                'max_wait_time'         => env("RPC_SIDECAR_AUTO_REJECT_MAX_WAIT_TIME", 15000),
            ],
            /**
             * worker 回收
             */
            'gc'                        => [
                // worker 回收检查间隔
                'time_interval'     => env("RPC_SIDECAR_GC_TIME_INTERVAL", 30),
                // worker处理n个请求后回收
                'max_process_count' => env("RPC_SIDECAR_GC_MAX_PROCESS_COUNT", 5000),
                // worker存活 n (秒) 后回收
                'max_life_second'   => env("RPC_SIDECAR_GC_MAX_LIFE_SECOND", 3600),
                // 当次最大处理时间(秒) 超时强制 kill
                'max_busy_second'   => env("RPC_SIDECAR_GC_MAX_BUSY_SECOND", 300),
                // 内存使用率超过该值之后，开始回收旧的worker
                'memory_watermark'  => env("RPC_SIDECAR_GC_MEMORY_WATERMARK", 90),
                // cpu使用率超过该值之后，开始回收旧的worker
                'cpu_watermark'     => env("RPC_SIDECAR_GC_CPU_WATERMARK", 90),
            ],
        ],
        "php"      => [
            "service_name" => env('RPC_SERVER_NAME', 'NoName'),
            // 配置符合版本的php执行文件 > 7.4
            "base_cmd"     => env("RPC_SIDECAR_PHP_BASE_CMD", "php"),
            "exec_file"    => path_join(base_path(), "artisan"),
            "start_cmd"    => "rpc:server",
            // 指定运行php程序时使用的ini文件(可用于项目个性化的本地ini文件，如xdebug配置)
            "ini_file"     => env("RPC_SIDECAR_PHP_INI_FILE", get_cfg_var('cfg_file_path')),
        ],
        "sls"      => [
            'server'  => [
                // 日志中心地址
                'address' => env("RPC_SIDECAR_SLS_SERVER_ADDRESS", "127.0.0.1:3455"),
            ],
            'channel' => [
                'log'   => 5,
                'error' => 6,
            ],
        ],
    ],
];
