<?php

return [
    'service_name' => env('RPC_SERVER_NAME', 'NoName'),
    'log_driver'   => env('RPC_LOG_DRIVER', in_array(config('app.env', "local"), ['dev', 'production']) ? 'sls' : 'local'),

    /**
     * rpc api url generation strategy
     */
    'url'          => [
        /**
         * enable auto add url prefix
         */
        'enable_prefix' => !env('RPC_DISABLE_URL_PREFIX', false),

        /**
         * auto add url prefix
         */
        'prefix'        => env("RPC_URL_PREFIX", "/".snake_case(env('RPC_SERVER_NAME', 'NoName'))),
    ],

    /**
     * cron config
     */
    'cron'         => [
        'enable' => env('RPC_CRON_ENABLE', true),
    ],

    'gc'      => [
        /**
         * run force gc when lifetime is full
         */
        'max_lifetime' => 60,

        /**
         * run force gc probability when request is complete
         */
        'probability'  => 5,
    ],

    /**
     * sidecar config (can rewrite by env)
     */
    'sidecar' => [
        'enable_setting' => env('RPC_SIDECAR_SETTING', false),
        'hostname'       => env("RPC_SIDECAR_HOSTNAME", null),
        'auto_reload'    => [
            'enable'    => config('app.env') == "local",
            'watch_dir' => env("RPC_SIDECAR_AUTO_RELOAD_WATCH_DIR", app_path()),
        ],

        "etcd"    => [
            'server_address' => env("RPC_SIDECAR_ETCD_SERVER_ADDRESS", "127.0.0.1:2379"),
            'dial_timeout'   => env("RPC_SIDECAR_ETCD_DIAL_TIMEOUT", "5"),
        ],
        'metrics' => [
            'host'        => env("RPC_SIDECAR_METRICS_SERVER_HOST", "0.0.0.0"),
            'port'        => env("RPC_SIDECAR_METRICS_SERVER_PORT", "0"),
            'push_enable' => env("RPC_SIDECAR_METRICS_PUSH_ENABLE", false),
            'push_url'    => env("RPC_SIDECAR_METRICS_PUSH_URL", "http://127.0.0.1:9091"),
        ],

        "log" => [
            'enable_load_debug' => env("RPC_SIDECAR_LOG_ENABLE_LOAD_DEBUG", false),
            'file'              => [
                "path"  => env("RPC_SIDECAR_LOG_FILE_PATH", storage_path("logs/service/sidecar.log")),
                "level" => env("RPC_SIDECAR_LOG_FILE_LEVEL", 'debug'),
            ],
            'console'           => [
                "enable" => env("RPC_SIDECAR_LOG_CONSOLE_ENABLE", true),
                "level"  => env("RPC_SIDECAR_LOG_CONSOLE_LEVEL", 'debug'),
            ],
        ],

        "rabbitmq" => [
            'enable'   => env("RPC_SIDECAR_RABBIT_ENABLE", true),
            'username' => env("RPC_SIDECAR_RABBIT_USERNAME", "manto"),
            'password' => env("RPC_SIDECAR_RABBIT_PASSWORD", "guest"),
            'host'     => env("RPC_SIDECAR_RABBIT_HOST", "127.0.0.1"),
            'port'     => env("RPC_SIDECAR_RABBIT_PORT", "5672"),
        ],
        "worker"   => [
            'min_worker_num'            => env("RPC_SIDECAR_WORKER_MIN_WORKER_NUM", 18),
            'max_worker_num'            => env("RPC_SIDECAR_WORKER_MAX_WORKER_NUM", 500),
            'num_lock_memory_watermark' => env("RPC_SIDECAR_WORKER_NUM_LOCK_MEMORY_WATERMARK", 80),
            'num_lock_cpu_watermark'    => env("RPC_SIDECAR_WORKER_NUM_LOCK_CPU_WATERMARK", 80),
            'scale_down_load'           => env("RPC_SIDECAR_WORKER_SCALE_DOWN_LOAD", 60),
            'scale_down_duration'       => env("RPC_SIDECAR_WORKER_SCALE_DOWN_DURATION", 60000),
            'scale_up_load'             => env("RPC_SIDECAR_WORKER_SCALE_UP_LOAD", 80),
            'scale_up_clam'             => env("RPC_SIDECAR_WORKER_SCALE_UP_CLAM", 300),
            'server'                    => [
                'host' => env("RPC_SIDECAR_WORKER_SERVER_HOST", "0.0.0.0"),
                'port' => env("RPC_SIDECAR_WORKER_SERVER_PORT", "2233"),
            ],
            'auto_reject'               => [
                'max_size'              => env("RPC_SIDECAR_AUTO_REJECT_MAX_SIZE", 500),
                'reject_mode_size'      => env("RPC_SIDECAR_AUTO_REJECT_REJECT_MODE_SIZE", 100),
                'reject_mode_wait_time' => env("RPC_SIDECAR_AUTO_REJECT_REJECT_MODE_WAIT_TIME", 3000),
                'max_wait_time'         => env("RPC_SIDECAR_AUTO_REJECT_MAX_WAIT_TIME", 15000),
            ],
            'gc'                        => [
                'time_interval'     => env("RPC_SIDECAR_GC_TIME_INTERVAL", 30),
                'max_process_count' => env("RPC_SIDECAR_GC_MAX_PROCESS_COUNT", 5000),
                'max_life_second'   => env("RPC_SIDECAR_GC_REJECT_MAX_LIFE_SECOND", 3600),
                'max_busy_second'   => env("RPC_SIDECAR_GC_MAX_BUSY_SECOND", 300),
                'memory_watermark'  => env("RPC_SIDECAR_GC_MEMORY_WATERMARK", 90),
                'cpu_watermark'     => env("RPC_SIDECAR_GC_MEMORY_WATERMARK", 90),
            ],
        ],
        "php"      => [
            "service_name" => env('RPC_SERVER_NAME', 'NoName'),
            "base_cmd"     => env("RPC_SIDECAR_PHP_BASE_CMD", "php"),
            "exec_file"    => path_join(base_path(), "artisan"),
            "start_cmd"    => "rpc:server",
            "ini_file"     => env("RPC_SIDECAR_PHP_INI_FILE", get_cfg_var('cfg_file_path')),
        ],
        "sls"      => [
            'server'  => [
                'address' => env("RPC_SIDECAR_SLS_SERVER_ADDRESS", "127.0.0.1:3455"),
            ],
            'channel' => [
                'log'   => 5,
                'error' => 6,
            ],
        ],
    ],
];
