<?php

namespace Mainto\MRPC\Service\Struct;

use Illuminate\Contracts\Support\Arrayable;

class Path implements Arrayable {

    /**
     * @var string|null
     */
    private ?string $httpUrl = null;

    /**
     * @var string|null
     */
    private ?string $httpMethod = null;

    /**
     * @var array
     */
    private array $headers = [];

    /**
     * @var array
     */
    private array $responseHeader = [];

    /**
     * @var string
     */
    private string $format = "json";

    /**
     * @var array
     */
    private array $needAuthority = [];

    /**
     * @var string|null
     */
    private ?string $messageHookName = null;

    /**
     * @var string
     */
    private string $class = "";

    /**
     * @var string
     */
    private string $method = "";

    /**
     * @return string|null
     */
    public function getHttpUrl (): ?string {
        return $this->httpUrl;
    }

    /**
     * @param string $httpUrl
     */
    public function setHttpUrl (string $httpUrl): void {
        $this->httpUrl = $httpUrl;
    }

    /**
     * @return string|null
     */
    public function getHttpMethod (): ?string {
        return $this->httpMethod;
    }

    /**
     * @param string $httpMethod
     */
    public function setHttpMethod (string $httpMethod): void {
        $this->httpMethod = $httpMethod;
    }

    /**
     * @return array
     */
    public function getHeaders (): array {
        return $this->headers;
    }

    /**
     * @param string $header
     */
    public function addHeader (string $header): void {
        $this->headers[] = $header;
    }

    /**
     * @return array
     */
    public function getResponseHeaders (): array {
        return $this->responseHeader;
    }

    /**
     * @param string $name
     * @param string $value
     */
    public function addResponseHeader (string $name, string $value): void {
        $this->responseHeader[$name] = $value;
    }

    /**
     * @param string $name
     */
    public function addAuthority (string $name): void {
        $this->needAuthority[] = $name;
    }

    /**
     * @return string
     */
    public function getFormat (): string {
        return $this->format;
    }

    /**
     * @param string $format
     */
    public function setFormat (string $format): void {
        $this->format = $format;
    }

    /**
     * @return string
     */
    public function getMessageHookName (): string {
        return $this->messageHookName;
    }

    /**
     * @param string $messageHookName
     */
    public function setMessageHookName (string $messageHookName): void {
        $this->messageHookName = $messageHookName;
    }

    public function toArray () {
        return [
            'class'           => $this->class,
            'method'          => $this->method,
            'http_method'     => $this->httpMethod,
            'http_url'        => $this->httpUrl,
            'format'          => $this->format,
            'accept_upload'   => false, // todo AccessUpload
            'response_header' => $this->responseHeader,
            'headers'         => $this->headers,
            'need_authority'  => $this->needAuthority,

            'message_hook_name' => $this->messageHookName,
        ];
    }

    public function setClass (string $className) {
        $this->class = $className;
    }

    public function setMethod (string $methodName) {
        $this->method = $methodName;
    }

    /**
     * @return string
     */
    public function getClass (): string {
        return $this->class;
    }

    /**
     * @return string
     */
    public function getMethod (): string {
        return $this->method;
    }
}