<?php


namespace Mainto\MRPC\Server\Worker;


use Mainto\MRPC\Protocol\Common\Body;
use Mainto\MRPC\Protocol\Common\Types\RequestHeaderType;
use Mainto\MRPC\Protocol\Request\Request;
use Mainto\MRPC\Protocol\Response\Response;
use Mainto\MRPC\Protocol\RpcUnixConnection;
use Mainto\MRPC\Server\RpcRouter;
use Mainto\MRPC\Tool\Net\Conn;
use RuntimeException;

class MasterHandler extends BaseHandler {
    private static ?MasterHandler $instance = null;

    public static function newInstance (): MasterHandler {
        if (self::$instance == null) {
            cli_set_process_title(sprintf("rpc-php [%s] [master] master", config('rpc-server.service_name')));

            self::$instance = new self();
        }

        return self::$instance;
    }

    public function onRequest (Request $request): Response {
        switch ($request->getType()) {
            case RequestHeaderType::ServiceScaleType :
                $collection = $request->getBody()->toCollection();
                $unix = $collection->get("unix");
                $childId = pcntl_fork();
                if ($childId < 0) {
                    throw new RuntimeException("fork fail");
                } elseif ($childId == 0) {
                    //                    $this->close();
                    RpcUnixConnection::newInstance($unix, new ChildHandler($unix))->start();
                }
                return $this->okResponse();
            case RequestHeaderType::ServiceConfigType:
                return self::serviceConfigResponse();
            case RequestHeaderType::SystemCheckType:
                return $this->systemCheckResponse();
        }

        return $this->requestUnknownResponse();
    }

    public function onClose (Conn $socket) {
    }

    public static function serviceConfigResponse () {
        $response = new Response();
        $response->useReturnOKType();

        $body = Body::newJsonBody(json_encode(RpcRouter::getInstance()->getBaseRouterConfig()));
        $response->setBody($body);

        return $response;
    }
}