<?php


namespace Mainto\RpcServer\Log;


use Monolog\Handler\AbstractProcessingHandler;
use Monolog\Logger;

class LogHandler extends AbstractProcessingHandler {
    /**
     * @var resource
     */
    private static $stream = null;

    public function __construct ($level = Logger::DEBUG, $bubble = true) {
        parent::__construct($level, $bubble);

        self::init(storage_path("logs/service"), "master");
    }

    public static function init ($dir, string $logId) {
        self::closeStream();

        @mkdir($dir, 0777, true);
        self::$stream = fopen($dir.'/'.$logId.'.log', 'a');
    }

    private static function closeStream () {
        if (self::$stream !== null) {
            fclose(self::$stream);
            self::$stream = null;
        }
    }

    protected function write (array $record) {
        fwrite(self::$stream, (string)$record['formatted']);
    }

    public function close () {
        self::closeStream();
    }
}