<?php


namespace Mainto\MRPC\Tool;


use Mainto\MRPC\Tool\IO\ReadCloser;
use RuntimeException;

class Socket implements ReadCloser {
    /**
     * Socket
     */
    private $socket;
    private string $server;
    private string $port;

    /**
     * RpcSocket constructor.
     * @param $server
     * @param $port
     */
    public function __construct (string $server, string $port) {
        $this->server = $server;
        $this->port = $port;

        $this->socket = @socket_create(AF_INET, SOCK_STREAM, SOL_TCP);

        if (!@socket_connect($this->socket, $server, $port)) {
            throw new RuntimeException("connect to {$server}:{$port} error");
        }
    }


    /**
     *  Sends data on the connection.
     *
     * @param string $sendBuffer
     * @return int
     */
    public function send (string $sendBuffer) {
        return socket_write($this->socket, $sendBuffer);
    }

    /**
     * read data on the connection.
     *
     * @param int $maxLength
     * @return string
     */
    public function read ($maxLength = 10240) :string {
        $res = socket_read($this->socket, $maxLength);
        if ($res === false || $res === "") {
            throw new RuntimeException(sprintf("socket read [%s] error: ". socket_last_error($this->socket), $res === false ? 'false' : 'empty'));
        }

        return $res;
    }

    /**
     * Close connection.
     *
     * @return void
     */
    public function close () {
        @socket_close($this->socket);
    }
}