<?php


namespace Mainto\MRPC\Server\Worker;


use Illuminate\Support\Facades\Log;
use Mainto\MRPC\Protocol\Common\Types\RequestHeaderType;
use Mainto\MRPC\Protocol\Request\Request;
use Mainto\MRPC\Protocol\Response\Response;
use Mainto\MRPC\Protocol\RpcConnection;
use Mainto\MRPC\Server\RpcInvoke;
use Mainto\MRPC\Service\RpcRouter;
use Mainto\MRPC\Tool\Socket;
use ReflectionMethod;

class Child extends RpcConnection {
    protected string $streamId = "child";

    /**
     * @param string $server
     * @param string $port
     * @param string $streamId
     */
    public function __construct (string $server, string $port, string $streamId) {
        cli_set_process_title(sprintf("rpc-php [%s] [%s] child", config('rpc-server.service_name'), $streamId));

        parent::__construct($server, $port, $streamId);
    }

    public function onRequest (Request $request): Response {
        switch ($request->getType()) {
            case RequestHeaderType::SystemCheckType:
                return $this->serviceDefaultResponse();
            case RequestHeaderType::InvokeNormalType:
            case RequestHeaderType::UrlInvokeDeleteType:
            case RequestHeaderType::UrlInvokePatchType:
            case RequestHeaderType::UrlInvokePostType:
            case RequestHeaderType::UrlInvokePutType:
            case RequestHeaderType::UrlInvokeGetType:
            case RequestHeaderType::MessageNormalType:
            case RequestHeaderType::CronNormalType:
                return RpcInvoke::invoke($request);
        }

        return $this->serviceDefaultResponse();
    }

    public function onClose (Socket $socket) {
        // TODO: Implement onClose() method.
    }

    public static function initRequest (): Request {
        $request = new Request();
        $request->setType(RequestHeaderType::ServiceChildConnType);

        return $request;
    }
}