<?php

namespace Mainto\MRPC\Server;

use Mainto\MRPC\Protocol\Request\Request;
use Mainto\MRPC\Server\ContextTrait\HeaderTrait;
use Mainto\MRPC\Server\ContextTrait\ParamTrait;

class RpcContext {
    use ParamTrait;
    use HeaderTrait;

    /**
     * @var Request
     */
    private Request $request;

    private string $session_id;

    /**
     * RpcRequest constructor.
     * @param Request $request
     * @param RpcParams $params
     */
    public function __construct (Request $request, RpcParams $params) {
        $this->rpcParams = $params;
        $this->session_id = "todo"; // X-Auth-StreamId
        $this->request = $request;
    }

    /**
     * @return Request
     */
    public function getRequest (): Request {
        return $this->request;
    }
}