<?php


namespace Mainto\MRPC\Protocol\Response\Extend;


use Mainto\MRPC\Protocol\Response\Extend;
use Mainto\MRPC\Protocol\Response\HeaderExtend;
use Mainto\MRPC\Tool\Binary;
use Mainto\MRPC\Tool\Bytes\Bytes;
use Mainto\MRPC\Tool\IO\Reader;
use Mainto\MRPC\Tool\IO\Writer;
use Mainto\MRPC\Tool\Reader\LittleEndianReader;

class ResponseHeaderExtend implements HeaderExtend {
    private array $header = [];

    public function magicNum () {
        return Extend::MagicNumUrlInvoke;
    }

    public function addHeader (string $key, string $value) {
        if (strlen($key) < 255 && strlen($value) < 65535) {
            if (!isset($this->header[$key])) {
                $this->header[$key] = [];
            }

            $this->header[$key][] = $value;
        }
    }

    public function setHeader(string $key, array $values) {
        if (strlen($key) > 255) {
            return;
        }

        foreach ($values as $value) {
            if ($value >= 65535) {
                return;
            }
        }

        $this->header[$key] = $values;
    }

    /**
     * @return array
     */
    public function getAllHeader (): array {
        return $this->header;
    }

    /**
     * @param string $key
     * @return array
     */
    public function getHeader (string $key): array {
        return $this->header[$key];
    }

    public function writeHeaderTo (Writer $writer): int {
        $buffer = Bytes::newBuffer();

        if ($this->header) {
            $buffer->writeByte(Binary::intToUint8(count($this->header)));

            foreach ($this->header as $key => $values) {
                $buffer->writeByte(Binary::intToUint8(strlen($key)));
                $buffer->writeString($key);

                $buffer->writeByte(Binary::intToUint8(count($values)));
                foreach ($values as $value) {
                    $buffer->writeByte(Binary::$littleEndian::intToUint16(strlen($value)));
                    $buffer->writeString($value);
                }
            }
        }

        return $buffer->writeTo($writer);
    }

    public function readHeaderFrom (Reader $reader): int {
        $littleEndianReader = new LittleEndianReader($reader);

        $headerLen = $littleEndianReader->readerUint8();

        if ($headerLen > 0) {
            for ($i = 0; $i < $headerLen; $i++) {
                $keySize = $littleEndianReader->readerUint8();

                $key = $littleEndianReader->read($keySize);
                $valueLen = $littleEndianReader->readerUint8();

                $values = [];

                for ($j = 0; $j < $valueLen; $j++) {
                    $valueSize = $littleEndianReader->readerUint16();
                    $values[] = $littleEndianReader->read($valueSize);
                }

                $this->header[$key] = $values;
            }
        }

        return $littleEndianReader->getTotalReaderSize();
    }
}