<?php


namespace Mainto\MRPC\Protocol\Request\Extend;


use Mainto\MRPC\Protocol\Request\BodyExtend;
use Mainto\MRPC\Protocol\Request\Extend;
use Mainto\MRPC\Protocol\Request\HeaderExtend;
use Mainto\MRPC\Tool\Binary;
use Mainto\MRPC\Tool\Bytes\Bytes;
use Mainto\MRPC\Tool\IO\Reader;
use Mainto\MRPC\Tool\IO\Writer;
use Mainto\MRPC\Tool\Reader\LittleEndianReader;

class RequestUrlInvokeExtend implements HeaderExtend, BodyExtend {
    private array $header = [];
    private array $query = [];
    private array $file = [];

    public function magicNum () {
        return Extend::MagicNumUrlInvoke;
    }

    private function checkAndAdd(array &$map, string $key, string $value) {
        if (strlen($key) < 255 && strlen($value) < 65535) {
            if (!isset($map[$key])) {
                $map[$key] = [];
            }

            $map[$key][] = $value;
        }
    }

    private function checkAndSet(array &$map, string $key, array $values) {
        if (strlen($key) > 255) {
            return;
        }

        foreach ($values as $value) {
            if ($value >= 65535) {
                return;
            }
        }

        $map[$key] = $values;
    }

    public function addHeader (string $key, string $value) {
       $this->checkAndAdd($this->header, $key, $value);
    }

    public function setHeader(string $key, array $values) {
        $this->checkAndSet($this->header, $key, $values);
    }

    public function checkParams () {
    }

    /**
     * @return array
     */
    public function getAllHeader (): array {
        return $this->header;
    }

    /**
     * @param string $key
     * @return array
     */
    public function getHeader (string $key): array {
        return $this->header[$key];
    }

    public function setQuery(string $key, array $values) {
        $this->checkAndSet($this->query, $key, $values);
    }

    /**
     * @return array
     */
    public function getAllQuery (): array {
        return $this->query;
    }

    /**
     * @param string $key
     * @return array
     */
    public function getQuery (string $key): array {
        return $this->query[$key];
    }

    public function addFile(string $key, Reader $reader) {
        $this->file[$key] = $reader;
    }

    public function writeBodyTo (Writer $writer): int {
        if ($this->file) {
            throw new \RuntimeException("current not support file upload");
        }

        return 0;
    }

    public function readBodyFrom (Reader $reader): int {
        // todo current not support file upload
        return 0;
    }

    public function writeHeaderTo (Writer $writer): int {
        $buffer = Bytes::newBuffer();

        if ($this->header) {
            $buffer->writeByte(Binary::intToUint8(count($this->header)));

            foreach ($this->header as $key => $values) {
                $buffer->writeByte(Binary::intToUint8(strlen($key)));
                $buffer->writeString($key);

                $buffer->writeByte(Binary::intToUint8(count($values)));
                foreach ($values as $value) {
                    $buffer->writeByte(Binary::$littleEndian::intToUint16(strlen($value)));
                    $buffer->writeString($value);
                }
            }
        }

        return $buffer->writeTo($writer);
    }

    public function readHeaderFrom (Reader $reader): int {
        $littleEndianReader = new LittleEndianReader($reader);

        $headerLen = $littleEndianReader->readerUint8();

        if ($headerLen > 0) {
            for ($i = 0; $i < $headerLen; $i++) {
                $keySize = $littleEndianReader->readerUint8();

                $key = $littleEndianReader->read($keySize);
                $valueLen = $littleEndianReader->readerUint8();

                $values = [];

                for ($j = 0; $j < $valueLen; $j++) {
                    $valueSize = $littleEndianReader->readerUint16();
                    $values[] = $littleEndianReader->read($valueSize);
                }

                $this->header[$key] = $values;
            }
        }

        return $littleEndianReader->getTotalReaderSize();
    }
}