<?php


namespace Mainto\MRPC\Client;


use RuntimeException;

class RpcClass {
    private static array $instances = [];

    private string $cacheKey;

    /**
     * @var Client|null
     */
    private ?Client $client;

    private string $serviceName;

    private string $className;

    protected function __construct (string $cacheKey, ?Client $client, string $serviceName, string $className) {
        $this->cacheKey = $cacheKey;
        $this->client = $client;
        $this->serviceName = $serviceName;
        $this->className = $className;
    }

    /**
     * 获得一个远程调用实例（如果有设置 Mock，获得的是 Mock 实例）
     *
     * @param $serviceName
     * @param $className
     * @return RpcClass
     */
    public static function getClass ($serviceName, $className): self {
        $key = "{$serviceName}->{$className}";
        if (!isset(self::$instances[$key])) {
            self::$instances[$key] = new RpcClass($key, self::getRemoteClient($serviceName), $serviceName, $className);
        }

        return self::$instances[$key];
    }

    /**
     * 获取远程调用客户端
     *
     * @param $serviceName
     * @return Client
     */
    protected static function getRemoteClient ($serviceName): Client {
        $client = Client::getInstanceByServiceName($serviceName);
        if (!$client) {
            throw new RuntimeException("can not find or connect to server {$serviceName}");
        }

        return $client;
    }

}