<?php


namespace Mainto\RpcServer\RpcUtil\Block;


use Mainto\RpcServer\Exceptions\RpcRuntimeException;
use Mainto\RpcServer\Protocol\Common\Body;
use Mainto\RpcServer\Protocol\Response\Response;

/**
 * Class ReturnBlock
 * @package Mainto\RpcServer\RpcUtil\Block
 * @deprecated
 */
class ReturnBlock extends Response {
    public function __construct (string $action = "", $message = []) {
        switch ($action) {
            case "auth" :
                // 'expire_time' => $expireTime,
                ['action' => $authAction, 'message' => $authMessage] = $message;

                $this->setBody(Body::newJsonBody($authMessage));

                switch ($authAction) {
                    case "authorize":
                        $this->useReturnAuthInvokeType();
                        break;
                    case "revoke":
                        $this->useReturnAuthRevokeType();
                        break;
                    default:
                        throw new RpcRuntimeException("not support this auth action: ".$authAction);
                }

                break;
            default:
                throw new RpcRuntimeException("not support this action: ".$action);
        }
    }
}