<?php
namespace Mainto\RpcServer\Service\Struct;


use Illuminate\Contracts\Support\Arrayable;

class Cron implements Arrayable {

    /**
     * @var string
     */
    private string $spec = "";

    /**
     * @var string
     */
    private string $cronHookName = "";

    /**
     * @var string
     */
    private string $class = "";
    /**
     * @var string
     */
    private string $method = "";

    /**
     * @param string $spec
     * @param $every
     * @param $entry
     */
    public function setSpec ($spec, $every, $entry): void {
        $every and $this->spec = '@every '.$every;
        $entry and $this->spec = '@'.$entry;
        $spec and $this->spec = str_replace('\\', '/', $spec);
    }

    /**
     * @return string
     */
    public function getCronHookName () {
        return $this->cronHookName;
    }

    /**
     * @param string $key
     */
    public function setCronHookName ($key): void {
        $this->cronHookName = 'cron-'.snake_case(config('rpc-server.service_name')).'-'.$key;
    }

    public function setClass (string $className) {
        $this->class = $className;
    }

    public function setMethod (string $methodName) {
        $this->method = $methodName;
    }

    /**
     * @return string
     */
    public function getClass (): string {
        return $this->class;
    }

    /**
     * @return string
     */
    public function getMethod (): string {
        return $this->method;
    }

    /**
     * Get the instance as an array.
     *
     * @return array
     */
    public function toArray () {
        return [
            'class'          => $this->class,
            'method'         => $this->method,
            'spec'           => $this->spec,
            'cron_hook_name' => $this->cronHookName,
        ];
    }
}