<?php

if (!function_exists('path_join')) {
    function path_join(...$args) {
        $path = "";
        foreach ($args as $arg) {
            if (!$arg) continue;

            $path .= $path ? (DIRECTORY_SEPARATOR . trim($arg, DIRECTORY_SEPARATOR)) : rtrim($arg, DIRECTORY_SEPARATOR);
        }

        return $path;
    }
}

if (!function_exists('remove_all')) {
    function remove_all($dir) {
        $files = array_diff(scandir($dir), array('.','..'));
        foreach ($files as $file) {
            (is_dir("$dir/$file")) ? remove_all("$dir/$file") : unlink("$dir/$file");
        }
        return rmdir($dir);
    }
}

if (!function_exists('count_cpus')) {
    /**
     * Get cpu counts
     *
     * @return int
     */
    function count_cpus () {
        $numCpus = 1;
        if (is_file('/proc/cpuinfo')) {
            $cpuinfo = file_get_contents('/proc/cpuinfo');
            preg_match_all('/^processor/m', $cpuinfo, $matches);
            $numCpus = count($matches[0]);
        } else if ('WIN' == strtoupper(substr(PHP_OS, 0, 3))) {
            $process = @popen('wmic cpu get NumberOfCores', 'rb');
            if (false !== $process) {
                fgets($process);
                $numCpus = intval(fgets($process));
                pclose($process);
            }
        } else {
            $process = @popen('sysctl -a', 'rb');
            if (false !== $process) {
                $output = stream_get_contents($process);
                preg_match('/hw.ncpu: (\d+)/', $output, $matches);
                if ($matches) {
                    $numCpus = intval($matches[1][0]);
                }
                pclose($process);
            }
        }

        return intval($numCpus) <= 0 ? 1 : intval($numCpus);
    }
}