<?php
/**
 * Created by PhpStorm.
 * User: PHPStorm
 * Date: 18-10-22
 * Time: 下午3:17
 */

namespace Mainto\RpcServer\Providers;

use Doctrine\Common\Annotations\AnnotationRegistry;
use Mainto\RpcServer\Command\RpcSidecarCommand;
use Mainto\RpcServer\Command\RpcServerCommand;
use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcServer\RpcRouter;
use Mainto\RpcServer\RpcServer\RpcSessionHandlerInterface;
use Mainto\RpcServer\RpcUtil\Tool\RpcMutexProviderInterface;

class ServiceProvider extends \Illuminate\Support\ServiceProvider {
    /**
     * Bootstrap the application services.
     *
     * @return void
     */
    public function boot () {
        if ($this->app->runningInConsole()) {

            $this->publishes([
                __DIR__.'/../config.php' => config_path('rpc-server.php'),
            ], 'config');
        }
    }

    /**
     * Register the application services.
     *
     * @return void
     */
    public function register () {
        $this->mergeConfigFrom(__DIR__.'/../config.php', 'rpc-server');

        $this->app->bind('command.rpc.sidecar', RpcSidecarCommand::class);
        $this->app->bind('command.rpc.server', RpcServerCommand::class);

        $this->commands([
            'command.rpc.sidecar',
            'command.rpc.server',
        ]);

        $this->app->singleton('rpc-server', fn() => RpcRouter::getInstance());

        $loader = new RpcAnnotationLoader();
        // todo remove
        AnnotationRegistry::registerLoader([$loader, "loadClass"]);

        $this->app->singleton(RpcMutexProviderInterface::class, function () {
            $lock = RpcClass::getClass("CoreGear", "Lock");

            return new class($lock) implements RpcMutexProviderInterface {
                private static $lock;

                public function __construct ($lock) {
                    self::$lock = $lock;
                }

                public static function getLock (string $lockName, int $expireTime = 600) {
                    return self::$lock->getLock([
                        "lockName"   => $lockName,
                        "expireTime" => $expireTime,
                    ]);
                }

                public static function unLock (string $lockName, string $password): bool {
                    return self::$lock->unlock([
                        "lockName" => $lockName,
                        "password" => $password,
                    ]);
                }
            };
        });

        $this->app->singleton(RpcSessionHandlerInterface::class, function () {
            $store = RpcClass::getClass("CoreGear", "Store");

            return new class($store) implements RpcSessionHandlerInterface {
                private static $store;

                public function __construct ($store) {
                    self::$store = $store;
                }

                public function getSessionStringBySessionId ($sessionId): ?string {
                    return self::$store->get([
                        "key" => $sessionId,
                    ]);
                }

                public function updateSession ($sessionId, $sessionString, $seconds): void {
                    self::$store->set([
                        "key"        => $sessionId,
                        "value"      => $sessionString,
                        "expireTime" => $seconds,
                    ]);
                }

                public function deleteSession ($sessionId): void {
                    self::$store->delete([
                        "key" => $sessionId,
                    ]);
                }
            };
        });
    }
}
