<?php


namespace Mainto\RpcServer\RpcUtil\Setting;


use RuntimeException;

class RpcSettingProxy extends RpcSetting {
    /**
     * @var int
     */
    private int $version;

    /**
     * @var array
     */
    private array $props;

    /**
     * RpcSettingProxy constructor.
     * @param int $version
     * @param array $props
     */
    public function __construct (int $version, array $props) {
        parent::__construct();

        $this->props = $props;
        $this->version = $version;
    }

    /**
     * get config version
     *
     * @return int
     */
    public function getVersion (): int {
        return $this->version;
    }

    /**
     * get props
     *
     * @param $name
     * @return mixed
     */
    public function __get ($name) {
        if (!isset($this->props[$name])) {
            throw new RuntimeException("can not find {$name} prop");
        }

        return $this->props[$name];
    }

    /**
     * set props
     *
     * @param $name
     * @param $value
     */
    public function __set ($name, $value) {
        throw new RuntimeException("setting class is read only, can not set {$name} prop");
    }

    /**
     * to array
     *
     * @return array
     */
    public function toArray () {
        return $this->props;
    }
}