<?php


namespace Mainto\MRPC\Protocol\Response\Extend;


use Mainto\MRPC\Protocol\Response\Extend;
use Mainto\MRPC\Tool\Binary;
use Mainto\MRPC\Tool\Bytes\Bytes;
use Mainto\MRPC\Tool\IO\Reader;
use Mainto\MRPC\Tool\IO\Writer;
use Mainto\MRPC\Tool\Reader\LittleEndianReader;

class HeaderExtend extends Extend {
    private array $header = [];

    public function magicNum () {
        return parent::MagicNumUrlInvoke;
    }

    public function writeTo (Writer $writer): int {
        $buffer = Bytes::newBuffer();

        if ($this->header) {
            $buffer->writeByte(Binary::intToUint8(count($this->header)));

            foreach ($this->header as $key => $values) {
                $buffer->writeByte(Binary::intToUint8(strlen($key)));
                $buffer->writeString($key);

                $buffer->writeByte(Binary::intToUint8(count($values)));
                foreach ($values as $value) {
                    $buffer->writeByte(Binary::intToUint8(strlen($value)));
                    $buffer->writeString($value);
                }
            }
        }

        return $buffer->writeTo($writer);
    }

    public function ReadFrom (Reader $reader): int {
        $littleEndianReader = new LittleEndianReader($reader);

        $headerLen = $littleEndianReader->readerUint8();

        if ($headerLen > 0) {
            for ($i = 0; $i < $headerLen; $i++) {
                $keySize = $littleEndianReader->readerUint8();

                $key = $littleEndianReader->read($keySize);
                $valueLen = $littleEndianReader->readerUint8();

                $values = [];

                for ($j = 0; $j < $valueLen; $j++) {
                    $valueSize = $littleEndianReader->readerUint8();
                    $values[] = $littleEndianReader->read($valueSize);
                }

                $this->header[$key] = $values;
            }
        }

        return $littleEndianReader->getTotalReaderSize();
    }

    public function addHeader (string $key, string $value) {
        if (strlen($key) < 255 && strlen($value) < 255) {
            if (!isset($this->header[$key])) {
                $this->header[$key] = [];
            }

            $this->header[$key][] = $value;
        }
    }
}