<?php
/**
 * Created by PhpStorm.
 * User: liuzaisen
 * Date: 2018/7/30
 * Time: 上午10:07
 */

namespace Mainto\RpcServer\RpcAnnotations;

use Doctrine\Common\Annotations\Annotation;
use Doctrine\Common\Annotations\Annotation\Attribute;
use Doctrine\Common\Annotations\Annotation\Attributes;


/**
 * Class RpcCron
 * @package Mainto\RpcServer\RpcAnnotations
 * @Annotation
 *
 * @Attributes({
 *     @Attribute("entry", type="string"),
 *     @Attribute("every", type="string"),
 *     @Attribute("spec", type="string"),
 * })
 */
class RpcCron {

    /**
     * @var string
     * @Enum({"weekly", "hourly", "daily", "monthly", "yearly"})
     */
    public string $entry = "";

    /**
     * @var string eg 1h30m -> 每过一小时30分钟
     */
    public string $every = "";

    /**
     * @see https://www.cnblogs.com/zuxingyu/p/6023919.html
     * cron 格式的字符串
     *
     * @var string
     */
    public string $spec = "";
}