<?php

namespace Mainto\RpcServer\Command;


use Illuminate\Console\Command;
use Mainto\RpcServer\Command\Sidecar\Sidecar;

class RpcSidecarCommand extends Command {
    const SidecarUrl = "https://s3.code.hzmantu.com/";

    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'rpc:sidecar {option?} {arg?}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'RPC Sidecar Command';

    /**
     * 可用的 Command
     * @var array
     */
    private $commands = [
        'start',
        'config',
        'download',
    ];

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct () {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle () {
        $command = $this->argument('option');
        $arg = $this->argument('arg');

        if (!$command || !in_array($command, $this->commands)) {
            dd('Usage: php artisan rpc:sidecar {download|start|config} {worker}');
        }
        if (!$arg && ($command != 'download' && $command != 'config')) {
            dd('Usage: php artisan rpc:sidecar {download|start|config} {worker}');
        }
        $sidecar = new Sidecar(self::SidecarUrl);

        switch ($command) {
            case "download":
                $sidecar->downloadSidecar();
                break;
            case "start":
                $sidecar->downloadSidecar();
                $sidecar->genConfig();
                chdir(dirname($sidecar->getRunFile()));
                system(sprintf("%s %s", $sidecar->getRunFile(), $arg));
                break;
            case "config":
                $sidecar->genConfig();
                break;
        }

        return 0;
    }
}
