<?php


namespace Mainto\RpcServer\Service\Struct;


use Illuminate\Contracts\Support\Arrayable;

class Websocket implements Arrayable {
    /**
     * @var bool
     */
    private bool $needConnectMessage = false;

    /**
     * @var bool
     */
    private bool $needDisconnectMessage = false;

    /**
     * @var string
     */
    private string $roomName = "";

    /**
     * @var string
     */
    private string $class = "";
    /**
     * @var string
     */
    private string $method = "";

    public function setClass (string $className) {
        $this->class = $className;
    }

    public function setMethod (string $methodName) {
        $this->method = $methodName;
    }

    /**
     * @return string
     */
    public function getClass (): string {
        return $this->class;
    }

    /**
     * @return string
     */
    public function getMethod (): string {
        return $this->method;
    }

    public function toArray () {
        return [
            'class'                   => $this->class,
            'method'                  => $this->method,
            'room_name'               => $this->roomName,
            'need_connect_message'    => $this->needConnectMessage,
            'need_disconnect_message' => $this->needDisconnectMessage,
        ];
    }

    public function isEmpty (): bool {
        return $this->roomName === "";
    }

    /**
     * @return string
     */
    public function getRoomName (): string {
        return $this->roomName;
    }

    /**
     * @param string $roomName
     */
    public function setRoomName (string $roomName): void {
        $this->roomName = $roomName;
    }

    /**
     * @return bool
     */
    public function isNeedConnectMessage (): bool {
        return $this->needConnectMessage;
    }

    /**
     * @param bool $needConnectMessage
     */
    public function setNeedConnectMessage (bool $needConnectMessage): void {
        $this->needConnectMessage = $needConnectMessage;
    }

    /**
     * @return bool
     */
    public function isNeedDisconnectMessage (): bool {
        return $this->needDisconnectMessage;
    }

    /**
     * @param bool $needDisconnectMessage
     */
    public function setNeedDisconnectMessage (bool $needDisconnectMessage): void {
        $this->needDisconnectMessage = $needDisconnectMessage;
    }
}