<?php


namespace Mainto\RpcServer\RpcServer;


use Mainto\RpcServer\Protocol\Response\Response;
use Mainto\RpcServer\RpcUtil\RpcGCHelper;
use Mainto\RpcServer\Util\Net\Conn;

abstract class BaseConnectionHandler implements ConnectionHandler {
    protected Response $cacheResponse;

    public function __construct () {
        $this->cacheResponse = new Response();
    }

    public function onSent (Conn $conn): bool {
        // hit gc
        RpcGCHelper::getInstance()->hitGC();

        return true;
    }
}