<?php


namespace Mainto\MRPC\Server\Worker;


use Mainto\MRPC\Protocol\Common\Body;
use Mainto\MRPC\Protocol\Common\Types\RequestHeaderType;
use Mainto\MRPC\Protocol\Request\Request;
use Mainto\MRPC\Protocol\Response\Response;
use Mainto\MRPC\Protocol\RpcConnection;
use Mainto\MRPC\Server\RpcRouter;
use Mainto\MRPC\Tool\Socket;
use RuntimeException;

class Master extends RpcConnection {

    protected string $streamId = "master";

    private static ?Master $instance = null;

    /**
     * @param string $server
     * @param string $port
     * @param string $streamId
     */
    protected function __construct (string $server, string $port, string $streamId) {
        parent::__construct($server, $port, "master-".$streamId);
    }

    public static function newInstance(string $server, string $port, string $streamId): Master {
        if (self::$instance == null) {
            self::$instance = new self($server, $port, $streamId);
        }

        cli_set_process_title(sprintf("rpc-php [%s] [%s] master", config('rpc-server.service_name'), $streamId));

        return self::$instance;
    }

    public function onRequest (Request $request): Response {
        switch ($request->getType()) {
            case RequestHeaderType::ServiceScaleType :
                $collection = $request->getBody()->toCollection();
                $key = $collection->get("key");
                $childId = pcntl_fork();
                if ($childId < 0) {
                    throw new RuntimeException("fork fail");
                } elseif ($childId == 0) {
//                    $this->close();
                    (new Child($this->server, $this->port, $key))->start();
                }
                break;
            case RequestHeaderType::ServiceConfigType:
                return self::serviceConfigResponse();
            case RequestHeaderType::SystemCheckType:
                return $this->serviceDefaultResponse();
        }

        return $this->serviceDefaultResponse();
    }

    public function onClose (Socket $socket) {
    }

    public static function serviceConfigResponse() {
        $response = new Response();
        $response->useReturnOKType();

        $body = Body::newJsonBody(json_encode(RpcRouter::getInstance()->getBaseRouterConfig()));
        $response->setBody($body);

        return $response;
    }

    public static function initRequest (): Request {
        $request = new Request();
        $request->setType(RequestHeaderType::ServiceMasterConnType);

        return $request;
    }
}