<?php


namespace Mainto\RpcServer\RpcServer\Connection;


use Mainto\RpcServer\RpcServer\BaseRpcConnection;
use Mainto\RpcServer\RpcServer\ConnectionHandler;
use Mainto\RpcServer\Util\Net\Net;

class RpcTcpConnection extends BaseRpcConnection {
    /**
     * RpcTcpConnection constructor.
     * @param string $address
     * @param $streamId
     * @param ConnectionHandler $handler
     */
    private function __construct (string $address, $streamId,  ConnectionHandler $handler) {
        parent::__construct(Net::dial("tcp", $address), $streamId, $handler);
    }

    public static function newInstance(string $address, $streamId,  ConnectionHandler $handler) {
        return new self($address, $streamId, $handler);
    }
}